clear all;close all;clc
load AllgazeJan2023 % loads gaze, including fixation information (Fa)
ppvalid=[1:20 23:36];

for i=1:length(ppvalid)
    pp=ppvalid(i);
    if pp<10
        filename1=['Data\RESULTS0' num2str(pp) '.txt'];
    else
        filename1=['Data\RESULTS' num2str(pp) '.txt'];
    end
    PPresults(i)=tdfread(filename1); %#ok<SAGROW>
end

PPr=NaN(34,9,45); % 34 participants, 9 variables x 45 trials
for i=1:34 % loop over participants
    PPr(i,1,:)=PPresults(i).compat;
    PPr(i,2,:)=PPresults(i).length;
    PPr(i,3,:)=strcmp(string(PPresults(i).response),'Left ')+2*strcmp(string(PPresults(i).response),'Right');
    PPr(i,4,:)=PPresults(i).valid; % is the trial valid (1) or not' (0)
    PPr(i,5,:)=strcmp(string(PPresults(i).ANS_VALIDITY),'''CORRECT''  ')+0*strcmp(string(PPresults(i).ANS_VALIDITY),'''INCORRECT''');
    PPr(i,6,:)=PPresults(i).SOUND_START;
    PPr(i,7,:)=PPresults(i).DISP_START;
    PPr(i,8,:)=PPresults(i).KEY_RT;
    PPr(i,9,:)=str2double(string(PPresults(i).RT));
end
%%
% 1 = audio condition, 2 = time budget, 3 = left (1) vs. right (2), 4 = valid (2) or invalid (1)
unique_condition_codes=[1112
    2112
    3112
    1122
    2122
    3122
    
    1312
    2312
    3312
    1322
    2322
    3322
    
    1612
    2612
    3612
    1622
    2622
    3622
    
    1121
    2111
    1311
    2321];
% 1 = Danger
% 2 = Go
% 3 = Baseline

% 1, 3, 6 s

% 1 = left, 2 = right
% 1 = invalid, 2 = valid
ConditionNames={'Danger - 1 s - Escape Left'
    'Go - 1 s - Escape Left'
    'Baseline - 1 s - Escape Left'
    'Danger - 1 s - Escape Right'
    'Go - 1 s - Escape Right'
    'Baseline - 1 s - Escape Right'
    
    'Danger - 3 s - Escape Left'
    'Go - 3 s - Escape Left'
    'Baseline - 3 s - Escape Left'
    'Danger - 3 s - Escape Right'
    'Go - 3 s - Escape Right'
    'Baseline - 3 s - Escape Right'
    
    'Danger - 6 s - Escape Left'
    'Go - 6 s - Escape Left'
    'Baseline - 6 s - Escape Left'
    'Danger - 6 s - Escape Right'
    'Go - 6 s - Escape Right'
    'Baseline - 6 s - Escape Right'
    
    'Go - 1 s - Escape Right - Invalid'
    'Danger - 1 s - Escape Left - Invalid'
    'Go - 3 s - Escape Left - Invalid'
    'Danger - 3 s - Escape Right - Invalid'};

[FFs,FFs2,FFs3]=deal(zeros(34,22,8)); % number of first and second fixations on AOIs)
FFc=NaN(34,22); % number of trials with eye-tracking data
PPs=NaN(34,22,7);
FFt=NaN(34,22,3,2); % first fixation time on left region and right region
[XAs,YAs,PAs]=deal(NaN(34,22,14100)); % X,Y,and Pupil data for each video and audio combination
for i=1:34
    data_of_participant=squeeze(PPr(i,:,:))';
    condition_code=1000*(data_of_participant(:,1)+1)+data_of_participant(:,2)/10+data_of_participant(:,3)*10+data_of_participant(:,4)+1;
    for i2=1:length(unique_condition_codes)
        temp=find(condition_code==unique_condition_codes(i2)); % find the trials that correspond to a specific video and audio combination
        
        r=data_of_participant(temp,5);
        rt=data_of_participant(temp,9);
        ft=squeeze(Fa(i,temp,:,:));
        xt=squeeze(Xa(i,temp,:,:));
        yt=squeeze(Ya(i,temp,:,:));
        pt=squeeze(Pa(i,temp,:,:));
        
        if length(temp)==1 % create right matrix dimensionality if there is only 1 trial
            ft2(1,:,:)=ft;ft=ft2;
            xt2(1,:,:)=xt;xt=xt2;
            yt2(1,:,:)=yt;yt=yt2;
        end
        XAs(i,i2,:)=nanmean(xt,1); % store X, Y, and Pupil date for each specific video and audio combination (average across trials)
        YAs(i,i2,:)=nanmean(yt,1);
        PAs(i,i2,:)=nanmean(pt,1);
        FFc(i,i2)=sum(sign(sum(~isnan(xt')))); % number of trials with eye-tracking data for that specific video and audio combination
        for t=1:length(temp) % loop over trials of that type
            
            ftt = squeeze(ft(t,:,:)); % fixation data of that trial
            AOInr=ftt(find(ismember(ftt(:,7),[1 2 3 4 5 7 8]),1,'first'),7); % AOI number of FIRST fixation other than the dashboard
            if ~isempty(AOInr)
                FFs(i,i2,AOInr)=FFs(i,i2,AOInr)+1; % first fixation count for that trial
            end
            
            AOInr=ftt(find(ismember(ftt(:,7),[1 2 3 4 5 7 8]),2,'first'),7); % AOI number of SECOND fixation other than the dashboard
            if length(AOInr)==2
                AOInr=AOInr(2);
            else
                AOInr=[];
            end
            if ~isempty(AOInr)
                FFs2(i,i2,AOInr)=FFs2(i,i2,AOInr)+1; % first fixation count for that trial
            end
            
            AOInr=ftt(find(ismember(ftt(:,7),[1 2 3 4 5 7 8]),3,'first'),7); % AOI number of SECOND fixation other than the dashboard
            if length(AOInr)==3
                AOInr=AOInr(3);
            else
                AOInr=[];
            end
            if ~isempty(AOInr)
                FFs3(i,i2,AOInr)=FFs3(i,i2,AOInr)+1; % first fixation count for that trial
            end

            
            fft=ftt(find(ismember(ftt(:,7),[1 2 3 4 5 7 8]),1,'first'),1); % All
            if ~isempty(fft)
                FFt(i,i2,t,1)=fft; % first fixation time for that trial
            end
            
            fft=ftt(find(ismember(ftt(:,7),3),1,'first'),1); % Road center
            if ~isempty(fft)
                FFt(i,i2,t,2)=fft; % first fixation time for that trial
            end
            
        end
        
        
        valid_reponses_of_participant=find(rt>0 & rt<=data_of_participant(temp(1),2)+300);
        invalid_reponses_of_participant=find(~ismember(1:length(temp),valid_reponses_of_participant));
        
        r(invalid_reponses_of_participant)=0; % set response to 'incorrect'
        
        rt(invalid_reponses_of_participant)=NaN; % set response time to 'NaN'
        
        PPs(i,i2,1)=100*nanmean(r); % percentage correct
        PPs(i,i2,2)=nanmean(rt); % mean response time
        PPs(i,i2,3)=100-100*length(valid_reponses_of_participant)/length(temp); % percentage invalid responses (same as 00*mean(isnan(rt)))
        PPs(i,i2,4)=length(temp); % number of responses in total
        PPs(i,i2,5)=sum(r==1); % number of correct responses
        PPs(i,i2,6)=sum(r==0); % number of incorrect responses; late responses were also incorrect
        end
end

PPm=squeeze(nanmean(PPs,1));
%% Figure 5. Response accuracy with 95% confidence intervals.
% figure;hold on
subplot(1,6,1)
h=bar(PPm(1:3,1),'facecolor','flat','barwidth',1);
h.CData(1,:) = [0.8 0 0];
h.CData(2,:) = [0.7 0.7 0.7];
h.CData(3,:) = [.1 .1 .1];
set(gca,'ylim',[45 100],'xticklabel',{'Danger','Go','Baseline'})
ylabel('Correct response (% of trials)')
title({'Escape left,','1-s video'})

subplot(1,6,2)
h=bar(PPm(4:6,1),'facecolor','flat','barwidth',1);
h.CData(1,:) = [0.8 0 0];
h.CData(2,:) = [0.7 0.7 0.7];
h.CData(3,:) = [.1 .1 .1];
set(gca,'ylim',[45 100],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
title({'Escape right,','1-s video'})

CI=within_subject_ci(squeeze(PPs(:,1:6,1)));
subplot(1,6,1);hold on
for i=1:3;plot([i i],[PPm(i,1)-CI(i) PPm(i,1)+CI(i)],'color',[0.5 0.5 1],'Linewidth',3);end
subplot(1,6,2);hold on
for i=1:3;plot([i i],[PPm(i+3,1)-CI(i+3) PPm(i+3,1)+CI(i+3)],'color',[0.5 0.5 1],'Linewidth',3);end

subplot(1,6,3)
h=bar(PPm(7:9,1),'facecolor','flat','barwidth',1);
h.CData(1,:) = [0.8 0 0];
h.CData(2,:) = [0.7 0.7 0.7];
h.CData(3,:) = [.1 .1 .1];
set(gca,'ylim',[45 100],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
title({'Escape left,','3-s video'})

subplot(1,6,4)
h=bar(PPm(10:12,1),'facecolor','flat','barwidth',1);
h.CData(1,:) = [0.8 0 0];
h.CData(2,:) = [0.7 0.7 0.7];
h.CData(3,:) = [.1 .1 .1];
set(gca,'ylim',[45 100],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
title({'Escape right,','3-s video'})

CI=within_subject_ci(squeeze(PPs(:,7:12,1)));
subplot(1,6,3);hold on
for i=1:3;plot([i i],[PPm(i+6,1)-CI(i) PPm(i+6,1)+CI(i)],'color',[0.5 0.5 1],'Linewidth',3);end
subplot(1,6,4);hold on
for i=1:3;plot([i i],[PPm(i+9,1)-CI(i+3) PPm(i+9,1)+CI(i+3)],'color',[0.5 0.5 1],'Linewidth',3);end

subplot(1,6,5)
h=bar(PPm(13:15,1),'facecolor','flat','barwidth',1);
h.CData(1,:) = [0.8 0 0];
h.CData(2,:) = [0.7 0.7 0.7];
h.CData(3,:) = [.1 .1 .1];
set(gca,'ylim',[45 100],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
title({'Escape left,','6-s video'})

subplot(1,6,6)
h=bar(PPm(16:18,1),'facecolor','flat','barwidth',1);
h.CData(1,:) = [0.8 0 0];
h.CData(2,:) = [0.7 0.7 0.7];
h.CData(3,:) = [.1 .1 .1];
set(gca,'ylim',[45 100],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
title({'Escape right,','6-s video'})

CI=within_subject_ci(squeeze(PPs(:,12:18,1)));
subplot(1,6,5);hold on
for i=1:3;plot([i i],[PPm(i+12,1)-CI(i) PPm(i+12,1)+CI(i)],'color',[0.5 0.5 1],'Linewidth',3);end
subplot(1,6,6);hold on
for i=1:3;plot([i i],[PPm(i+15,1)-CI(i+3) PPm(i+15,1)+CI(i+3)],'color',[0.5 0.5 1],'Linewidth',3);end

h=findobj('FontName','Helvetica');                                % Obtain plot font object
set(h,'FontSize',22);                                             % Increase font size

%% Figure 6. Mean response times with 95% confidence intervals.
figure;hold on
subplot(1,6,1)
h=bar(PPm(1:3,2),'facecolor','flat','barwidth',1);
h.CData(1,:) = [0.8 0 0];
h.CData(2,:) = [0.7 0.7 0.7];
h.CData(3,:) = [.1 .1 .1];
set(gca,'ylim',[0 4000],'xticklabel',{'Danger','Go','Baseline'})
ylabel('Mean response time (ms)')
title({'Escape left,','1-s video'})

subplot(1,6,2)
h=bar(PPm(4:6,2),'facecolor','flat','barwidth',1);
h.CData(1,:) = [0.8 0 0];
h.CData(2,:) = [0.7 0.7 0.7];
h.CData(3,:) = [.1 .1 .1];
set(gca,'ylim',[0 4000],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
title({'Escape right,','1-s video'})

CI=within_subject_ci(squeeze(PPs(:,1:6,2)));
subplot(1,6,1);hold on
for i=1:3;plot([i i],[PPm(i,2)-CI(i) PPm(i,2)+CI(i)],'color',[0.5 0.5 1],'Linewidth',3);end
subplot(1,6,2);hold on
for i=1:3;plot([i i],[PPm(i+3,2)-CI(i+3) PPm(i+3,2)+CI(i+3)],'color',[0.5 0.5 1],'Linewidth',3);end

subplot(1,6,3)
h=bar(PPm(7:9,2),'facecolor','flat','barwidth',1);
h.CData(1,:) = [0.8 0 0];
h.CData(2,:) = [0.7 0.7 0.7];
h.CData(3,:) = [.1 .1 .1];
set(gca,'ylim',[0 4000],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
title({'Escape left,','3-s video'})

subplot(1,6,4)
h=bar(PPm(10:12,2),'facecolor','flat','barwidth',1);
h.CData(1,:) = [0.8 0 0];
h.CData(2,:) = [0.7 0.7 0.7];
h.CData(3,:) = [.1 .1 .1];
set(gca,'ylim',[0 4000],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
title({'Escape right,','3-s video'})

CI=within_subject_ci(squeeze(PPs(:,7:12,2)));
subplot(1,6,3);hold on
for i=1:3;plot([i i],[PPm(i+6,2)-CI(i) PPm(i+6,2)+CI(i)],'color',[0.5 0.5 1],'Linewidth',3);end
subplot(1,6,4);hold on
for i=1:3;plot([i i],[PPm(i+9,2)-CI(i+3) PPm(i+9,2)+CI(i+3)],'color',[0.5 0.5 1],'Linewidth',3);end

subplot(1,6,5)
h=bar(PPm(13:15,2),'facecolor','flat','barwidth',1);
h.CData(1,:) = [0.8 0 0];
h.CData(2,:) = [0.7 0.7 0.7];
h.CData(3,:) = [.1 .1 .1];
set(gca,'ylim',[0 4000],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
title({'Escape left,','6-s video'})

subplot(1,6,6)
h=bar(PPm(16:18,2),'facecolor','flat','barwidth',1);
h.CData(1,:) = [0.8 0 0];
h.CData(2,:) = [0.7 0.7 0.7];
h.CData(3,:) = [.1 .1 .1];

CI=within_subject_ci(squeeze(PPs(:,13:18,2)));
subplot(1,6,5);hold on
for i=1:3;plot([i i],[PPm(i+12,2)-CI(i) PPm(i+12,2)+CI(i)],'color',[0.5 0.5 1],'Linewidth',3);end
subplot(1,6,6);hold on
for i=1:3;plot([i i],[PPm(i+15,2)-CI(i+3) PPm(i+15,2)+CI(i+3)],'color',[0.5 0.5 1],'Linewidth',3);end

set(gca,'ylim',[0 4000],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
title({'Escape right,','6-s video'})

h=findobj('FontName','Helvetica');                                % Obtain plot font object
set(h,'FontSize',22);                                             % Increase font size
%% AOI of fixation number 1, 2, and 3
disp('Number of trials with eye-tracking data')
disp(sum(sum(FFc,2)))
for i=1:3 % first fixation, second fixation
    if i==1
        d=100*[nanmean(FFs(:,:,1)./FFc);nanmean(FFs(:,:,2)./FFc);nanmean(FFs(:,:,3)./FFc);nanmean(FFs(:,:,4)./FFc);nanmean(FFs(:,:,5)./FFc);nanmean(FFs(:,:,7)./FFc);nanmean(FFs(:,:,8)./FFc)];
    elseif i==2
        d=100*[nanmean(FFs2(:,:,1)./FFc);nanmean(FFs2(:,:,2)./FFc);nanmean(FFs2(:,:,3)./FFc);nanmean(FFs2(:,:,4)./FFc);nanmean(FFs2(:,:,5)./FFc);nanmean(FFs2(:,:,7)./FFc);nanmean(FFs2(:,:,8)./FFc)];
    elseif i==3
        d=100*[nanmean(FFs3(:,:,1)./FFc);nanmean(FFs3(:,:,2)./FFc);nanmean(FFs3(:,:,3)./FFc);nanmean(FFs3(:,:,4)./FFc);nanmean(FFs3(:,:,5)./FFc);nanmean(FFs3(:,:,7)./FFc);nanmean(FFs3(:,:,8)./FFc)];
    end
    figure;hold on
    C = [0 0 0
        0.5 0.5 0.5
        1 0 0
        [115 195 108]/255
        [26 148 49]/255
        [255 204 0]/255
        0.301 0.745 0.933];
    colororder(C);
    subplot(1,6,1)
    h=bar(d(:,1:3)','stacked','facecolor','flat','barwidth',1);
    set(gca,'ylim',[0 100],'xticklabel',{'Danger','Go','Baseline'})
    if i==1
        ylabel('AOI of first fixaton (%)')
    elseif i==2
        ylabel('AOI of second fixaton (%)')
    elseif i==3
        ylabel('AOI of third fixaton (%)')
    end
title({'Escape left,','1-s video'})

l=legend('Left mirror','Left Road','Center road','Right road','Right mirror','Center mirror','Sky','orientation','horizontal');
    set(l,'Position',[0.18051887599032 0.957956219246968 0.669618055555556 0.0376775787523161]);
    subplot(1,6,2)
    h=bar(d(:,4:6)','stacked','facecolor','flat','barwidth',1);
    set(gca,'ylim',[0 100],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
    title({'Escape right,','1-s video'})

    subplot(1,6,3)
    h=bar(d(:,7:9)','stacked','facecolor','flat','barwidth',1);
    set(gca,'ylim',[0 100],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
    title({'Escape left,','3-s video'})

    subplot(1,6,4)
    h=bar(d(:,10:12)','stacked','facecolor','flat','barwidth',1);
    set(gca,'ylim',[0 100],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
    title({'Escape right,','3-s video'})

    subplot(1,6,5)
    h=bar(d(:,13:15)','stacked','facecolor','flat','barwidth',1);
    set(gca,'ylim',[0 100],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
title({'Escape left,','6-s video'})
    
    subplot(1,6,6)
    h=bar(d(:,16:18)','stacked','facecolor','flat','barwidth',1);
    set(gca,'ylim',[0 100],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
    title({'Escape right,','6-s video'})
h=findobj('FontName','Helvetica');                                % Obtain plot font object
    set(h,'FontSize',22);                                             % Increase font size
for i=1:6; subplot(1,6,i);a=get(gca,'pos');a(4)=0.75;set(gca,'pos',a);end

end

%% First fixation time
d=squeeze(nanmean(FFt(:,:,:,1),3));
dm=nanmean(d);
figure;hold on
subplot(1,6,1)
h=bar(dm(1:3),'facecolor','flat','barwidth',1);
h.CData(1,:) = [0.8 0 0];
h.CData(2,:) = [0.7 0.7 0.7];
h.CData(3,:) = [.1 .1 .1];
set(gca,'ylim',[0 400],'xticklabel',{'Danger','Go','Baseline'})
ylabel('First fixation time (ms)')
title({'Escape left,','1-s video'})

subplot(1,6,2)
h=bar(dm(4:6),'facecolor','flat','barwidth',1);
h.CData(1,:) = [0.8 0 0];
h.CData(2,:) = [0.7 0.7 0.7];
h.CData(3,:) = [.1 .1 .1];
set(gca,'ylim',[0 400],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
title({'Escape right,','1-s video'})

CI=within_subject_ci(squeeze(d(:,1:6)));
subplot(1,6,1);hold on
for i=1:3;plot([i i],[dm(i)-CI(i) dm(i)+CI(i)],'color',[0.5 0.5 1],'Linewidth',3);end
subplot(1,6,2);hold on
for i=1:3;plot([i i],[dm(i+3)-CI(i+3) dm(i+3)+CI(i+3)],'color',[0.5 0.5 1],'Linewidth',3);end

subplot(1,6,3)
h=bar(dm(7:9),'facecolor','flat','barwidth',1);
h.CData(1,:) = [0.8 0 0];
h.CData(2,:) = [0.7 0.7 0.7];
h.CData(3,:) = [.1 .1 .1];
set(gca,'ylim',[0 400],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
title({'Escape left,','3-s video'})

subplot(1,6,4)
h=bar(dm(10:12),'facecolor','flat','barwidth',1);
h.CData(1,:) = [0.8 0 0];
h.CData(2,:) = [0.7 0.7 0.7];
h.CData(3,:) = [.1 .1 .1];
set(gca,'ylim',[0 400],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
title({'Escape right,','3-s video'})

CI=within_subject_ci(squeeze(d(:,7:12)));
subplot(1,6,3);hold on
for i=1:3;plot([i i],[dm(i+6)-CI(i) dm(i+6)+CI(i)],'color',[0.5 0.5 1],'Linewidth',3);end
subplot(1,6,4);hold on
for i=1:3;plot([i i],[dm(i+9)-CI(i+3) dm(i+9)+CI(i+3)],'color',[0.5 0.5 1],'Linewidth',3);end

subplot(1,6,5)
h=bar(dm(13:15),'facecolor','flat','barwidth',1);
h.CData(1,:) = [0.8 0 0];
h.CData(2,:) = [0.7 0.7 0.7];
h.CData(3,:) = [.1 .1 .1];
set(gca,'ylim',[0 400],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
title({'Escape left,','6-s video'})

subplot(1,6,6)
h=bar(dm(16:18),'facecolor','flat','barwidth',1);
h.CData(1,:) = [0.8 0 0];
h.CData(2,:) = [0.7 0.7 0.7];
h.CData(3,:) = [.1 .1 .1];

CI=within_subject_ci(squeeze(d(:,13:18)));
subplot(1,6,5);hold on
for i=1:3;plot([i i],[dm(i+12)-CI(i) dm(i+12)+CI(i)],'color',[0.5 0.5 1],'Linewidth',3);end
subplot(1,6,6);hold on
for i=1:3;plot([i i],[dm(i+15)-CI(i+3) dm(i+15)+CI(i+3)],'color',[0.5 0.5 1],'Linewidth',3);end

set(gca,'ylim',[0 400],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
title({'Escape right,','6-s video'})
h=findobj('FontName','Helvetica');                                % Obtain plot font object
set(h,'FontSize',22);                                             % Increase font size

%% Figure S1. Percentage of trials with late or non-responses
figure;hold on
subplot(1,6,1)
h=bar(PPm(1:3,3),'facecolor','flat','barwidth',1);
h.CData(1,:) = [0.8 0 0];
h.CData(2,:) = [0.7 0.7 0.7];
h.CData(3,:) = [.1 .1 .1];
set(gca,'ylim',[[0 40]],'xticklabel',{'Danger','Go','Baseline'})
ylabel('No response (% of trials)')
title({'Escape left,','1-s video'})

subplot(1,6,2)
h=bar(PPm(4:6,3),'facecolor','flat','barwidth',1);
h.CData(1,:) = [0.8 0 0];
h.CData(2,:) = [0.7 0.7 0.7];
h.CData(3,:) = [.1 .1 .1];
set(gca,'ylim',[[0 40]],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
title({'Escape right,','1-s video'})

CI=within_subject_ci(squeeze(PPs(:,1:6,3)));
subplot(1,6,1);hold on
for i=1:3;plot([i i],[PPm(i,3)-CI(i) PPm(i,3)+CI(i)],'color',[0.5 0.5 1],'Linewidth',3);end
subplot(1,6,2);hold on
for i=1:3;plot([i i],[PPm(i+3,3)-CI(i+3) PPm(i+3,3)+CI(i+3)],'color',[0.5 0.5 1],'Linewidth',3);end

subplot(1,6,3)
h=bar(PPm(7:9,3),'facecolor','flat','barwidth',1);
h.CData(1,:) = [0.8 0 0];
h.CData(2,:) = [0.7 0.7 0.7];
h.CData(3,:) = [.1 .1 .1];
set(gca,'ylim',[[0 40]],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
title({'Escape left,','3-s video'})

subplot(1,6,4)
h=bar(PPm(10:12,3),'facecolor','flat','barwidth',1);
h.CData(1,:) = [0.8 0 0];
h.CData(2,:) = [0.7 0.7 0.7];
h.CData(3,:) = [.1 .1 .1];
set(gca,'ylim',[[0 40]],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
title({'Escape right,','3-s video'})

CI=within_subject_ci(squeeze(PPs(:,7:12,3)));
subplot(1,6,3);hold on
for i=1:3;plot([i i],[PPm(i+6,3)-CI(i) PPm(i+6,3)+CI(i)],'color',[0.5 0.5 1],'Linewidth',3);end
subplot(1,6,4);hold on
for i=1:3;plot([i i],[PPm(i+9,3)-CI(i+3) PPm(i+9,3)+CI(i+3)],'color',[0.5 0.5 1],'Linewidth',3);end

subplot(1,6,5)
h=bar(PPm(13:15,3),'facecolor','flat','barwidth',1);
h.CData(1,:) = [0.8 0 0];
h.CData(2,:) = [0.7 0.7 0.7];
h.CData(3,:) = [.1 .1 .1];
set(gca,'ylim',[[0 40]],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
title({'Escape left,','6-s video'})

subplot(1,6,6)
h=bar(PPm(16:18,3),'facecolor','flat','barwidth',1);
h.CData(1,:) = [0.8 0 0];
h.CData(2,:) = [0.7 0.7 0.7];
h.CData(3,:) = [.1 .1 .1];

CI=within_subject_ci(squeeze(PPs(:,13:18,3)));
subplot(1,6,5);hold on
for i=1:3;plot([i i],[PPm(i+12,3)-CI(i) PPm(i+12,3)+CI(i)],'color',[0.5 0.5 1],'Linewidth',3);end
subplot(1,6,6);hold on
for i=1:3;plot([i i],[PPm(i+15,3)-CI(i+3) PPm(i+15,3)+CI(i+3)],'color',[0.5 0.5 1],'Linewidth',3);end

set(gca,'ylim',[[0 40]],'yticklabel',[],'xticklabel',{'Danger','Go','Baseline'})
title({'Escape right,','6-s video'})

h=findobj('FontName','Helvetica');                                % Obtain plot font object
set(h,'FontSize',22);                                             % Increase font size
